<?php
/**
 * hphpa
 *
 * Copyright (c) 2012-2013, Sebastian Bergmann <sebastian@phpunit.de>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *
 *   * Neither the name of Sebastian Bergmann nor the names of his
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @package   hphpa
 * @author    Sebastian Bergmann <sebastian@phpunit.de>
 * @copyright 2012-2013 Sebastian Bergmann <sebastian@phpunit.de>
 * @license   http://www.opensource.org/licenses/BSD-3-Clause  The BSD 3-Clause License
 * @since     File available since Release 1.0.0
 */

namespace SebastianBergmann\HPHPA
{
    /**
     * Parser for HipHop CodeError.js logfile.
     *
     * @author    Sebastian Bergmann <sebastian@phpunit.de>
     * @copyright 2012-2013 Sebastian Bergmann <sebastian@phpunit.de>
     * @license   http://www.opensource.org/licenses/BSD-3-Clause  The BSD 3-Clause License
     * @link      http://github.com/sebastianbergmann/hphpa/tree
     * @since     Class available since Release 1.0.0
     */
    class Result
    {
        /**
         * @var array
         */
        protected $rules = array();

        /**
         * @var array
         */
        protected $violations = array();

        /**
         * @return array
         */
        public function getViolations()
        {
            return $this->violations;
        }

        /**
         * @param array $rules
         * @since Method available since Release 1.1.0
         */
        public function setRules(array $rules)
        {
            $this->rules = $rules;
        }

        /**
         * @param array $codeError
         */
        public function parse(array $codeError)
        {
            foreach ($codeError[1] as $rule => $violations) {
                if (!isset($this->rules[$rule]) || !is_array($violations)) {
                    continue;
                }

                foreach ($violations as $violation) {
                    $filename = $violation['c1'][0];
                    $line     = $violation['c1'][1];
                    $message  = sprintf(
                                  $this->rules[$rule],
                                  trim($violation['d'])
                                );

                    if (!isset($this->violations[$filename])) {
                        $this->violations[$filename] = array();
                    }

                    if (!isset($this->violations[$filename][$line])) {
                        $this->violations[$filename][$line] = array();
                    }

                    $this->violations[$filename][$line][] = array(
                      'message'  => $message,
                      'source'   => $rule
                    );
                }
            }
        }
    }
}
