# ClEmail - class for generation email messages

import os
import jinja2

# Subject line prefix in template file
SUBJECT_LINE_PREFIX = 'Subject:'


class ClEmail:
	def __init__(self):
		pass

	@staticmethod
	def generate_mail_jinja2(template_dir, templ_filename, templ_data=None, locale_name=None, subject=None):
		"""
		Generates email message using jinja2 template engine
		:param template_dir: Base templates directory
		:param templ_filename: Template filename
		:param templ_data: Data to fill template using jinja2
		:param locale_name: Locale
		:param subject: Email subject to use if it not found in template
		:return: Cortege (email_subject, email_body)
		"""
		# default locale is en_US
		def_locale = 'en_US'
		locale_name = locale_name or def_locale
		templ_dir = os.path.join(template_dir, locale_name)
		if locale_name != def_locale and not os.path.isfile(os.path.join(templ_dir, templ_filename)):
			templ_dir = os.path.join(template_dir, def_locale)
		template_file = os.path.join(templ_dir, templ_filename)
		# Read template file content
		f_template = open(template_file, "r")
		template_lines = f_template.readlines()
		f_template.close()
		# Search subject string in template content
		if len(template_lines) > 2 and template_lines[0].startswith(SUBJECT_LINE_PREFIX) and template_lines[1] == '\n':
			subject = template_lines[0].replace(SUBJECT_LINE_PREFIX, '').strip()
			# Remove Subject line and separator (empty line) from array
			template_lines.pop(1)
			template_lines.pop(0)
			pass
		# Create dictionary for jinja2 Dict Loader
		template_lines = [l.decode('utf-8') for l in template_lines]
		templ_dict = {templ_filename: ''.join(template_lines)}
		templ_loader = jinja2.DictLoader(templ_dict)
		templ_envir = jinja2.Environment(loader=templ_loader)
		body_message = templ_envir.get_template(templ_filename).render(templ_data)
		return subject, body_message.encode('utf-8')