/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.Datum;

class TimestampAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    TimestampAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.TIMESTAMP, oracleStatement, 11, bl);
        this.init(oracleStatement, 180, 180, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        super(Representation.TIMESTAMP, oracleStatement, 11, false);
        this.init(oracleStatement, 180, 180, s2, false);
        this.initForDescribe(180, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.getLength(n2);
        int n4 = this.oracleYear(this.tmpBytes);
        int n5 = -1;
        if (n3 == 11) {
            n5 = this.oracleNanos(this.tmpBytes);
        }
        int n6 = this.oracleHour(this.tmpBytes);
        String string = this.toText(n4, this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), n6, this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), n5, n6 < 12, null);
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        if (this.externalType == 0) {
            if (this.statement.connection.j2ee13Compliant) {
                return this.getTimestamp(n2);
            }
            return this.getTIMESTAMP(n2);
        }
        switch (this.externalType) {
            case 93: {
                return this.getTimestamp(n2);
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMP(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }
}

