# coding: utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT


from __future__ import print_function
from __future__ import division
from __future__ import absolute_import
import os

from clselect.baseclselect import ENABLED_STATUS, DISABLED_STATUS
from clselect.baseclselect.config import BaseSelectorConfig
from . import (
    CONFIG_DIR,
    create_config_dirs,
    ALT_NODE_PREFIX,
)


class NodeConfig(BaseSelectorConfig):
    """
    It's responsible for all interaction with CL NodeJS selector config file
    and computing some effective values when config is absent or incomplete
    """
    _config_file = os.path.join(CONFIG_DIR, 'selector.json')

    def __init__(self, pkg_manager):
        """
        :param pkg_manager: instance of PkgManager class
        """
        super(NodeConfig, self).__init__(pkg_manager)
        self.reload()

    def _create_config_dirs(self):
        """Forward calls to external function"""
        create_config_dirs()

    @property
    def available_versions(self):
        """
        Returns a dict with status of all installed alt-NodeJS versions
        :rtype: dict
        """
        disabled = self.Cfg.disabled_versions or []
        return {
            ver: {
                'status': DISABLED_STATUS if ver in disabled else ENABLED_STATUS,
                'base_dir': ALT_NODE_PREFIX + ver,
            }
            for ver in self.pkg.installed_versions
        }
