# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import print_function
from __future__ import division
from __future__ import absolute_import
import glob
import os
from future.moves import configparser as ConfigParser
from future.moves.configparser import SafeConfigParser


class ExtensionInfo(object):

    doc_url = 'https://npmjs.org/package'

    def __init__(self, npm=None):
        if npm:
            self.npm = npm
        else:
            self.npm = sorted(glob.glob('/opt/alt/alt-nodejs*/root/usr/bin/npm'))[-1]

    def list_extensions(self):
        raise NotImplementedError("It's not used for nodejs selector")

    def list_extensions_cached(self):
        raise NotImplementedError("It's not used for nodejs selector")

    def write_cache(self):
        raise NotImplementedError("It's not used for nodejs selector")

    def list_extensions_version(self, extensions):
        raise NotImplementedError("It's not used for nodejs selector")

    @staticmethod
    def delete_cache():
        raise NotImplementedError("It's not used for nodejs selector")

    @staticmethod
    def extension_doc(extension):
        return '/'.join([ExtensionInfo.doc_url, extension])

    @staticmethod
    def extensions_docs(extensions):
        docs = [ExtensionInfo.extension_doc(ext) for ext in extensions]
        return dict((ext, {'doc': doc}) for ext, doc in zip(extensions, docs))

    @staticmethod
    def get_locked_extensions(interpreter):
        alt_ver = interpreter.replace('.', '')
        file_path = os.path.join('/opt/alt', alt_ver, 'root', 'etc', 'locked_extensions.ini')
        if not os.path.exists(file_path):
            file_path = os.path.join(os.path.dirname(__file__), '..', 'locked_extensions.ini')
        parser = SafeConfigParser(interpolation=None, strict=False)
        parser.read(file_path)
        try:
            items = parser.items(interpreter)
        except ConfigParser.NoSectionError:
            items = ()

        return dict((extension, [v.strip() for v in versions.split(',') if v])
                    for extension, versions in items)

    @staticmethod
    def is_extensions_locked(locked_extensions, extension, version):
        return (extension in locked_extensions and (
            list(set([v.strip() for v in version.split(',') if len(version) > 0])
                & set(locked_extensions.get(extension))) or
            len(locked_extensions.get(extension)) == 0
        ))
