# coding=utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import print_function
from __future__ import division
from __future__ import absolute_import
from clselect.baseclselect.apps_manager import BaseApplicationsManager
from clselect.clselectnodejs.node_manager import NodeManager
from clselect.clselectnodejsuser.environments import APP_CONFIG


class ApplicationsManager(BaseApplicationsManager):

    _USER_CONFIG = '.cl.selector/node-selector.json'
    INTERPRETER = 'nodejs'
    VENV_DIR = 'nodevenv'
    BINARY_NAME = 'node'

    def __init__(self):
        super(ApplicationsManager, self).__init__(NodeManager())

    def _find_config_files(self, user_name, app_directory, patterns=(APP_CONFIG,)):

        return super(ApplicationsManager, self)._find_config_files(user_name, app_directory, patterns=patterns)

    @staticmethod
    def get_interpreter_specific_passenger_lines(binary_path, app_config):
        """
        Return lines for htaccess that are specific to the nodejs interpreter
        :param binary_path: path to the environment's node binary
        :param app_config: application's config dictionary
        """
        specific_lines = [
            'PassengerNodejs "{}"\n'.format(binary_path),
            'PassengerAppType node\n',
            'PassengerStartupFile {}\n'.format(app_config['startup_file']),
        ]
        return specific_lines
