# coding: utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import absolute_import
from __future__ import print_function
from __future__ import division
import sys
from clselect.baseclselect.selector_manager import BaseSelectorManager
from clselect.utils import is_imunify_using_python
from .config import PythonConfig
from .pkgmanager import PkgManager

API_1 = 1


class PythonManager(BaseSelectorManager):
    """Responsible for actual python selector high-level API"""

    def __init__(self, cfg=None, pkg=None):
        pkg = pkg or PkgManager()
        cfg = cfg or PythonConfig(pkg)                      #pylint: disable=E0110
        super(PythonManager, self).__init__(cfg, pkg)

    def uninstall_version(self, version: str):
        cur_system_version = f'{sys.version_info.major}.{sys.version_info.minor}'
        if version == cur_system_version or is_imunify_using_python(str(version)):
            return {
                'result': 'success',
                'warning': 'This Python version is used by system and cannot be removed'
            }
        return super(PythonManager, self).uninstall_version(version)