# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import print_function
from __future__ import division
from __future__ import absolute_import
from distutils import spawn
import getopt
import os
import re
import sys

from clselect.utils import mkdir_p


ACTIVATE_PATTERN = r'''deactivate () {
    if [ -n "$_OLD_VIRTUAL_PATH" ] ; then
        PATH="$_OLD_VIRTUAL_PATH"
        export PATH
        unset _OLD_VIRTUAL_PATH
    fi
    if [ -n "$BASH" -o -n "$ZSH_VERSION" ] ; then
        hash -r 2>/dev/null
    fi
    if [ -n "$_OLD_VIRTUAL_PS1" ] ; then
        PS1="$_OLD_VIRTUAL_PS1"
        export PS1
        unset _OLD_VIRTUAL_PS1
    fi
    unset VIRTUAL_ENV
    unset RUBYHOME
    unset GEM_HOME
    unset GEM_PATH
    unset GEM_SPEC_CACHE
    if [ ! "$1" = "nondestructive" ] ; then
        unset -f deactivate
    fi
}
deactivate nondestructive
VIRTUAL_ENV=$(cd "$(dirname "${BASH_SOURCE[0]}")/.." && pwd)
RUBYHOME="%s"
# set home directory if it is not for some reason
# (e.g. cagefs_enter in selectorctl)
# othewise recent ruby2.7 version fails to install gem
# with no valid reason in output (like "nil argument, exit")
if [[ "${HOME}" == "" ]]; then
    HOME="$(echo ~)"
    export HOME
fi
ORIG_GEM_HOME=$("$RUBYHOME/bin/gem" env --config-file "" GEM_HOME)
GEM_HOME="$VIRTUAL_ENV"
GEM_PATH="$VIRTUAL_ENV:$ORIG_GEM_HOME"
GEM_SPEC_CACHE="$GEM_HOME/specs"
export VIRTUAL_ENV
export RUBYHOME
export GEM_HOME
export GEM_PATH
export GEM_SPEC_CACHE
_OLD_VIRTUAL_PATH="$PATH"
PATH="$VIRTUAL_ENV/bin:$RUBYHOME/bin:$PATH"
export PATH
if [ -z "$VIRTUAL_ENV_DISABLE_PROMPT" ] ; then
    _OLD_VIRTUAL_PS1="$PS1"
    if [ "x%s" != x ] ; then
        PS1="%s$PS1"
    else
    if [ "`basename \"$VIRTUAL_ENV\"`" = "__" ] ; then
        PS1="[`basename \`dirname \"$VIRTUAL_ENV\"\``] $PS1"
    else
        PS1="(`basename \"$VIRTUAL_ENV\"`)$PS1"
    fi
    fi
    export PS1
fi
if [ -n "$BASH" -o -n "$ZSH_VERSION" ] ; then
    hash -r 2>/dev/null
fi
'''

WRAP_LIST = [
    ['ruby', []],
    ['gem', ['--config-file', '"$VIRTUAL_ENV/gemrc"']],
    ]

WRAPPER_PATTERN = r'''#!/bin/bash
PWD=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
source "$PWD/activate"
exec "$RUBYHOME/bin/%s" "$@"%s
'''


def create(destination, prompt='', ruby=None):
    destination = os.path.expanduser(destination)

    if not ruby:
        ruby = spawn.find_executable('ruby')

    if not os.path.isabs(ruby):
        ruby = os.path.realpath(ruby)

    ruby_home = os.path.dirname(os.path.dirname(ruby))
    basename = os.path.basename(ruby)
    version = re.match('ruby(?P<version>.*)', basename).groupdict()['version']
    venv_bin = os.path.join(destination, 'bin')

    mkdir_p(venv_bin)

    for binary, args in WRAP_LIST:
        bin_name = binary + version
        bin_abs = os.path.join(ruby_home, 'bin', bin_name)
        if not os.path.isfile(bin_abs):
            raise OSError(
                "%s binary does not exists '%s'" % (bin_name, ruby))
        wrapper_abs = os.path.join(venv_bin, binary)
        if args:
            args_str = str.join(' ', [''] + args)
        else:
            args_str = ''
        wrapper_file = open(wrapper_abs, 'w')
        wrapper_file.write(WRAPPER_PATTERN % (bin_name, args_str))
        wrapper_file.close()
        os.chmod(wrapper_abs, 0o755)

    activate_abs = os.path.join(venv_bin, 'activate')
    activate_file = open(activate_abs, 'w')
    activate_file.write(ACTIVATE_PATTERN % (ruby_home, prompt, prompt))
    activate_file.close()


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], 'p:r:', ['prompt=', 'ruby='])
    except getopt.GetoptError as err:
        print(str(err))
        usage()
        sys.exit(1)

    prompt = ''
    ruby = None

    if not args:
        print('no destination specified')
        usage()
        sys.exit(1)

    destination = args[0]

    for o, a in opts:
        if o in ('-p', '--prompt'):
            prompt = a
        elif o in ('-r', '--ruby'):
            ruby = a
        else:
            print('unhandled option')
            sys.exit(1)

    create(destination, prompt, ruby)


def usage():
    print('Usage: ' + sys.argv[0] + ' [OPTIONS] VENV')
    print()
    print('Options:')
    print(' -p, --prompt PROMPT   Set alternative prompt prefix for venv')
    print(' -r, --ruby PATH       Ruby interpreter to use to create new venv')
    print(' -h, --help            Show this message')


if __name__ == '__main__':
    main()
