#!/usr/bin/python
# -*- coding: utf-8 -*-


"""
CloudLinux control panel API
API for Hosting control panel
"""
import os
import sys

from cpapiexceptions import NotSupported
from const import CACHE_CPNAME, UNKNOWN_CP_NAME

# List api that try to to load
_API_IMPORTED = ['cpusers', 'resellers', 'db_access', 'dblogin_cplogin_pairs', 'cpinfo', 'get_admin_email', 'docroot',
                 'userdomains', 'homedirs']


# list supported api
_API_SUPPORTED = _API_IMPORTED + ['getCPName']

__all__ = _API_SUPPORTED


def getCPName():
    controlpanelname = UNKNOWN_CP_NAME
    if os.path.isfile(CACHE_CPNAME):
        cache_stream = open(CACHE_CPNAME)
        controlpanelname = cache_stream.readline().strip()
        cache_stream.close()
    return controlpanelname


CP_NAME = getCPName()


################## api functions for documenting ###########################

def cpusers():
    """
    Generates a list of cpusers registered in the control panel

    :return: list of cpusers registered in the control panel
    :rtype: tuple
    :raise: NotSupported
    """
    pass


def resellers():
    """
    Generates a list of resellers in the control panel

    :return: list of cpusers registered in the control panel
    :rtype: tuple
    :raise: NotSupported
    """
    pass


def db_access():
    """
    Getting root access to mysql database.
    For example {'login': 'root', 'db': 'mysql', 'host': 'localhost', 'pass': '9pJUv38sAqqW'}

    :return: root access to mysql database
    :rtype: dict
    :raises: NoDBAccessData, NotSupported
    """
    pass


def dblogin_cplogin_pairs(cplogin_lst=None, with_system_users=False):
    """
    Returs a list of pairs, the database user login - user login control panel
    For example:
        (('nata2_someuse', 'nata2'), ('testsome_dfrtbus', 'testsome'))
    :param list|tuple|None cplogin_lst: list of control panel users
    :param bool with_system_users: add system users to dbmapping
    :return: list of pairs, the database user login - user login control panel
    :rtype: tuple
    :raises: NotSupported, NoPackage
    """
    pass


def cpinfo(cpuser=None, keyls=('cplogin', 'package', 'mail', 'reseller', 'dns')):
    """
    keyls a list of data which is necessary to obtain the user, the values ​​can be:
       cplogin - name/login user control panel
       mail - Email users
       reseller - name reseller/owner users
       locale - localization of the user account
       package - User name of the package
       dns - domain of the user
    :param str|unicode|list|tuple|None cpuser: user login
    :return: returns a tuple of tuples of data in the same sequence as specified keys in keylst
    :rtype: tuple
    """
    return ()


def get_admin_email():
    """
    Gets admin email
    :return: string - admin email
    """
    return ""


def docroot(domain):
    """
    Return document root for domain
    :param str|unicode domain:
    :return str: document root for domain
    """
    return  ""


def userdomains(cpuser):
    """
    Return domain and document root pairs for control panel user
    first domain is main domain
    :param str|unicode cpuser: user login
    :return list of tuples (domain_name, documen_root)
    """
    return [()]

def homedirs():
    """
    Returns list of users' home dirs for particular detected panel
    In case of no panel it returns empty list
    :return list of home dirs
    """
    return []

# Loading api
from apilink import api as _apiplugin
_thismodule = sys.modules[__name__]
for _api_name in _API_IMPORTED:
    if hasattr(_apiplugin, _api_name):
        _api_func = getattr(_apiplugin, _api_name)
    else:
        def _api_func(*args, **kwargs):
            setattr(_api_func, 'not_support', '"%s" api not supported in "%s" control panel' % (_api_name, CP_NAME))
            # raise exception if function not present in plugin package
            raise NotSupported(_api_func.not_support)
    setattr(_thismodule, _api_name, _api_func)
