#!/usr/bin/python
# -*- coding: utf-8 -*-
from const import CLCPAPI_NAME


class NotSupported(Exception):
    def __init__(self, message):
        Exception.__init__(self, '%s: %s' % (CLCPAPI_NAME, message))


class NoDBAccessData(Exception):
    def __init__(self, message):
        Exception.__init__(self, '%s: %s' % (CLCPAPI_NAME, message))


class NoPackage(Exception):
    def __init__(self, message):
        Exception.__init__(self, '%s: %s' % (CLCPAPI_NAME, message))


class CpApiTypeError(Exception):
    def __init__(self, funcname=None, supportettypes=None, received_type=None):
        Exception.__init__(self, "%s: in function %s argument must be %s, not '%s'" % (
            CLCPAPI_NAME,
            funcname or '<api function>',
            supportettypes or '<supported types>',
            received_type or '<received type>'))


class PluginImportError(Exception):
    def __init__(self, message):
        Exception.__init__(self, '%s: %s' % (CLCPAPI_NAME, message))


class NoDomain(Exception):
    def __init__(self, message):
        Exception.__init__(self, '%s: %s' % (CLCPAPI_NAME, message))