# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
from __future__ import absolute_import
import argparse
from xml.dom import minidom, DOMException, NotFoundErr
from xml.parsers.expat import ExpatError


def set_governor_save_uid(config_path="/etc/container/mysql-governor.xml", save_uid=True):
    """

    :param str config_path:
    :param bool save_uid:
    :return:
    """
    try:
        governor_config = minidom.parse(config_path)
    except (IOError, ExpatError, DOMException):
        pass
    else:
        try:
            if save_uid:
                governor_config.getElementsByTagName("statistic")[0].setAttribute("save_uid", "On")
            else:
                governor_config.getElementsByTagName("statistic")[0].removeAttribute("save_uid")
        except (NotFoundErr, IndexError, KeyError):
            pass
        else:
            with open(config_path, 'w') as config_file:
                governor_config.writexml(config_file)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument(
        '--save_uid',
        action='store_true',
        dest='save_uid',
        default=False)
    opts = parser.parse_args()
    if opts.save_uid:
        set_governor_save_uid(save_uid=True)
    else:
        set_governor_save_uid(save_uid=False)
