#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
api that is suitable for both cPanel, Directadmin, interWorx
"""

try:
    import MySQLdb
except ImportError:
    MySQLdb = None
from clcommon.cpapi.cpapiexceptions import NoPackage


def _dblogin_cplogin_pairs(access, cplogin_lst=None, dbname='mysql'):
    """
    Extracting database login control panel login pairs from mysql database
    supported for cPanel, interWorx, Directadmin
    :param dblogin:
    :param dbpass:
    :param dbhost:
    :param dbname:
    :param cplogin_lst:
    :return:
    """
    if not MySQLdb:
        raise NoPackage('Can not connect to database; MySQL-python package not installed.')
    dbhost = access.get('host', 'localhost')
    dblogin = access['login']
    dbpass = access['pass']
    db = MySQLdb.connect(host=dbhost, user=dblogin, passwd=dbpass, db=dbname)
    cursor = db.cursor()
    sql = r"SELECT User, LEFT(Db, LOCATE('\\', Db) - 1) FROM db WHERE User != '' and Db LIKE '%\\\%'"
    if cplogin_lst:
        sql += r" and LEFT(Db, LOCATE('\\', Db) - 1) in ('%s')" % ("', '".join(cplogin_lst),)
    sql += r" GROUP BY User"
    cursor.execute(sql)
    data = cursor.fetchall()
    db.close()
    return data


def get_admin_email(_hostname=None):
    """
    Gets admin email
    :param str|None _hostname: hostname for testing
    :return: admin's email
    :rtype: string
    """
    import socket
    return 'root@' + (_hostname or socket.gethostname())