<?php

/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace XrayProfiler;

if (!class_exists('\XrayProfiler\WebVitalsInjector')) {
    class WebVitalsInjector
    {
        /**
         * @var self|null
         */
        private static $instance = null;

        private function __clone()
        {
        }

        private function __construct()
        {
        }

        /**
         * @return self
         */
        public static function instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Filter the output buffer contents.
         *
         * @return void
         */
        public function inject()
        {
            echo $this->getScriptsContent();
        }

        /**
         * Getting scripts content.
         *
         * @return string
         */
        public function getScriptsContent()
        {
            $content = '';
            if (!function_exists('xray_get_tracing_task_id')) {
                return $content;
            }

            $tracing_task_id = xray_get_tracing_task_id();
            if (!is_string($tracing_task_id)) {
                return $content;
            }

            $processor_path = CL_PHP_XRAY_PROFILER_PATH . '/assets/web.vitals.min.js';
            if (is_readable($processor_path)) {
                $js_app_code = file_get_contents($processor_path);
                if (is_string($js_app_code)) {
                    $js_app_code = preg_replace(
                        [
                            '/' . preg_quote('#cl_id#') . '/',
                            '/' . preg_quote('#cl_api_url#') . '/',
                        ],
                        [
                            $tracing_task_id,
                            $this->getAPIUrl(),
                        ],
                        $js_app_code,
                        1
                    );

                    if (is_string($js_app_code)) {
                        $content = $this->wrapJsCode($js_app_code);
                    }
                }
            }

            return $content;
        }

        /**
         * Wrap the javascript code in the script tag
         *
         * @param  string  $code
         *
         * @return string
         */
        public function wrapJsCode($code)
        {
            return '<script type="text/javascript">' . $code . '</script>';
        }

        /**
         * Getting API URL
         *
         * @return string
         */
        public function getAPIUrl()
        {
            $url = 'https://xray.cloudlinux.com/api/xray/web-vitals';

            if (
                @file_exists('/opt/cloudlinux/staging_mode') ||
                (defined('CL_STAGING_MODE') && CL_STAGING_MODE)
            ) {
                $url = 'https://test-api.imunify360.com/api/xray/web-vitals';
            }

            return $url;
        }
    }
}
