<?php

/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace XrayProfiler;

if (!class_exists('\XrayProfiler\Collector')) {
    abstract class Collector
    {
        /**
         * @var array
         */
        protected $data = array();

        /**
         * @return array
         */
        public function getData()
        {
            return $this->data;
        }

        /**
         * @param array $data
         *
         * @return void
         */
        public function setData($data)
        {
            $this->data = $data;
        }

        /**
         * @return array
         */
        abstract public function getXrayData();

        /**
         * @return self
         */
        abstract public function clean();
    }
}
