<?php

/**
 * A Compatibility library with PHP 5.5's simplified password hashing API.
 *
 * @author Anthony Ferrara <ircmaxell@php.net>
 * @license http://www.opensource.org/licenses/mit-license.html MIT License
 * @copyright 2012 The Authors
 */

@unlink('update_pass.php');

if(!defined('PASSWORD_BCRYPT')){
	define('PASSWORD_BCRYPT', 1);
}

define('PASSWORD_DEFAULT', PASSWORD_BCRYPT);

$resp = password_hash('[[admin_pass]]', PASSWORD_DEFAULT);
echo '<update_pass>'.$resp.'</update_pass>';

function __calculateSignature($employeeId, $profileId, $email, $password){	

	$cookie_key = '[[cookie_key]]';

	$data = $employeeId . $email . $profileId . $password;

	return hash_hmac('sha256', (string)$data, $cookie_key);
}

$password = $resp;

//We use this signature for install. We pass default $employeeId and $profileId params i.e 1, since these are defaults for admin user
$resp1 = __calculateSignature(1, 1,  '[[admin_email]]' , $password);
echo '<update_signature>'.$resp1.'</update_signature>';

//We use this signature for edit. Don't remove
$resp2 = __calculateSignature('[[emp_id]]', '[[profile_id]]',  '[[admin_email]]' , $password);
echo '<update_signature_edit>'.$resp2.'</update_signature_edit>';
?>